/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SaveAsDialog
extends DialogScreen {
    private final Pattern namePattern = Pattern.compile("[a-zA-Z][A-Za-z0-9_]*");
    private TextFieldWidget filename;
    private boolean errored;

    public SaveAsDialog(AnimatorScreen screen) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.save_as"), screen);
        this.setDimensions(140, 80);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int btnWidthP = this.dWidth() - 10;
        int btnWidth = (btnWidthP - 5) / 2;
        this.func_230480_a_(new LabelWidget(this.left() + 5, this.top() + 15, btnWidthP, 15, (ITextComponent)new StringTextComponent("Filename"), this.field_230712_o_));
        this.filename = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 30, btnWidthP, 20, StringTextComponent.field_240750_d_));
        this.filename.func_212954_a((Consumer)new SuggestionResponder("Filename", this.filename, this::filename_changed));
        this.errored = true;
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 55, btnWidth, 20, (ITextComponent)new StringTextComponent("Cancel"), this::cancel_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidth, this.top() + 55, btnWidth, 20, (ITextComponent)new StringTextComponent("Save"), this::save_clicked));
        this.updateSaveButtonState();
    }

    private void save_clicked(Button button) {
        Animator animator = Animator.get();
        AnimationProject project = animator.getProject();
        project.saveProjectAs(this.filename.func_146179_b());
        this.showParent();
    }

    private void filename_changed(String value) {
        if (this.namePattern.matcher(value).matches()) {
            this.filename.func_146193_g(0xE0E0E0);
            this.errored = false;
        } else {
            this.filename.func_146193_g(0xE00000);
            this.errored = true;
        }
        this.updateSaveButtonState();
    }

    private void updateSaveButtonState() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = !this.errored;
        }
    }
}

